# Desc: Check for valid conditions
# Called by: main:order(tag)
# Datapack made by TheDiamondPlayables

# Enables required scoreboards:
scoreboard players enable @a bl_info
scoreboard players enable @a bl_dinfo

# Checks for info function:
execute as @a[scores={bl_dinfo=1..}] run function blocklocker:info_message

# Tags all explosive entities:
tag @e[type=tnt] add explosive
tag @e[type=tnt_minecart] add explosive
tag @e[type=creeper] add explosive
tag @e[type=end_crystal] add explosive
tag @e[type=fireball] add explosive

# Checks for explosive disabling:
execute as @e[tag=explosive] at @s if entity @e[tag=blocklocked,distance=..5] run summon creeper ~ ~ ~ {ExplosionRadius:-1b,ignited:1b,Fuse:1s}
execute as @e[tag=explosive] at @s if entity @e[tag=blocklocked,distance=..5] run kill @s

# Checks for locked chest condition:
execute as @e[type=minecraft:item_frame,nbt={Item:{id:"minecraft:oak_sign",Count:1b,tag:{display:{Name:"{\"text\":\"Lock Me\"}"}}}}] at @s run function blocklocker:execute/message

# Checks for Owner Info:
execute as @a[scores={bl_info=1..}] at @s anchored eyes positioned ^ ^ ^2 unless score @s playerid = @e[tag=blocklocked,distance=..1,sort=nearest,limit=1] bl_ownerid run tellraw @s [{"text":"Block is locked!","color":"gold"},{"text":" Block Owner ID: ","color":"gold"},{"score":{"name":"@e[tag=blocklocked,distance=..2,sort=nearest,limit=1]","objective":"bl_ownerid"},"color":"green"}]
execute as @a[scores={bl_info=1..}] run scoreboard players reset @s bl_info

# Makes "blocklocker" go invisible and no colliding it
execute as @e[tag=blocklocked] at @s run effect give @s minecraft:invisibility 5 0 true
team join no_collide @e[tag=blocklocked,team=!no_collide]

# Checks for player input condition:
execute as @a[scores={bl_accept=1..}] run function blocklocker:execute/blocklock
execute as @a[scores={bl_deny=1..}] run function blocklocker:execute/deny

# Enables timer countdown if a timer exists:
execute as @a[scores={bl_timer=1..}] run scoreboard players remove @s bl_timer 1
execute as @e[tag=blocklocked,scores={bl_timer=1..}] run scoreboard players remove @s bl_timer 1

# Checks for block conditions:
execute as @e[tag=blocklocked] at @s store result entity @s Pos[1] double 0.1 run scoreboard players get @s bl_height
execute as @e[tag=blocklocked] at @s if block ~ ~0.2 ~ minecraft:air run function blocklocker:execute/exterminate
execute as @a at @s anchored eyes positioned ^ ^ ^2 if score @s playerid = @e[tag=blocklocked,distance=..2,sort=nearest,limit=1] bl_ownerid run execute as @e[tag=blocklocked,distance=..2,sort=nearest,limit=1] at @s run teleport @s ~ -10 ~